#include "ConstantBuffers.hlsli"
//--------------------------------------------------------------------------------------
// Vertex Shader for usual object (i.e. defined in viewspace objectSpace)
//--------------------------------------------------------------------------------------
static const float4 Light1_WPosition = 10.0f;
PS_INPUT main( float4 Pos : POSITION,  float2 Tex : TEXCOORD0, float3 Norm : NORMAL0 )
{
	PS_INPUT output = (PS_INPUT)0;
	output.Pos = mul( Pos, World );
    output.Pos = mul( output.Pos, View );
   
    output.Tex      = Tex;
    output.Nor      = mul( normalize(Norm), World ).xyz;
    //output.Nor      = mul( output.Nor, View );
    output.LightDir = normalize(Light1_WPosition.xyz - output.Pos);
    float3 wEyeDir  = View[3].xyz - output.Pos.xyz;
    output.HalfVect = normalize(0.5*( output.LightDir+wEyeDir));
    


    output.Pos = mul( output.Pos, Projection );
   // output.Nor = mul( output.Nor, Projection );
 
    return output;
}